// To parse this JSON data, do
//
//     final autoPaymentSuccessResponseModel = autoPaymentSuccessResponseModelFromJson(jsonString);

import 'dart:convert';

import 'package:viserpay/data/model/global/meassage_model.dart';

AutoPaymentSuccessResponseModel autoPaymentSuccessResponseModelFromJson(String str) => AutoPaymentSuccessResponseModel.fromJson(json.decode(str));

String autoPaymentSuccessResponseModelToJson(AutoPaymentSuccessResponseModel data) => json.encode(data.toJson());

class AutoPaymentSuccessResponseModel {
  String? remark;
  String? status;
  Message? message;
  Data? data;

  AutoPaymentSuccessResponseModel({
    this.remark,
    this.status,
    this.message,
    this.data,
  });

  factory AutoPaymentSuccessResponseModel.fromJson(Map<String, dynamic> json) => AutoPaymentSuccessResponseModel(
        remark: json["remark"],
        status: json["status"],
        message: json["message"] == null ? null : Message.fromJson(json["message"]),
        data: json["data"] == null ? null : Data.fromJson(json["data"]),
      );

  Map<String, dynamic> toJson() => {
        "remark": remark,
        "status": status,
        "message": message?.toJson(),
        "data": data?.toJson(),
      };
}

class Data {
  AutoPayment? autoPayment;

  Data({
    this.autoPayment,
  });

  factory Data.fromJson(Map<String, dynamic> json) => Data(
        autoPayment: json["auto_payment"] == null ? null : AutoPayment.fromJson(json["auto_payment"]),
      );

  Map<String, dynamic> toJson() => {
        "auto_payment": autoPayment?.toJson(),
      };
}

class AutoPayment {
  String? userId;
  String? paymentType;
  String? paymentDays;
  DateTime? nextPayment;
  String? amount;
  String? receiverId;
  String? updatedAt;
  String? createdAt;
  String? id;

  AutoPayment({
    this.userId,
    this.paymentType,
    this.paymentDays,
    this.nextPayment,
    this.amount,
    this.receiverId,
    this.updatedAt,
    this.createdAt,
    this.id,
  });

  factory AutoPayment.fromJson(Map<String, dynamic> json) => AutoPayment(
        userId: json["user_id"]?.toString(),
        paymentType: json["payment_type"]?.toString(),
        paymentDays: json["payment_days"]?.toString(),
        nextPayment: json["next_payment"] == null ? null : DateTime.parse(json["next_payment"]),
        amount: json["amount"]?.toString(),
        receiverId: json["receiver_id"]?.toString(),
        updatedAt: json["updated_at"]?.toString(),
        createdAt: json["created_at"]?.toString(),
        id: json["id"]?.toString(),
      );

  Map<String, dynamic> toJson() => {
        "user_id": userId,
        "payment_type": paymentType,
        "payment_days": paymentDays,
        "next_payment": "${nextPayment!.year.toString().padLeft(4, '0')}-${nextPayment!.month.toString().padLeft(2, '0')}-${nextPayment!.day.toString().padLeft(2, '0')}",
        "amount": amount,
        "receiver_id": receiverId,
        "updated_at": updatedAt,
        "created_at": createdAt,
        "id": id,
      };
}
